﻿# LS360-Terminal launcher (ship folder). Run from this directory.
$ErrorActionPreference = "Stop"
$AppRoot = $PSScriptRoot
$AgentExe = Join-Path $AppRoot "agent\LS360.Agent.exe"
$BridgeDir = Join-Path $AppRoot "bridge"
$SessionDir = Join-Path $AppRoot "session-service"
$UiDir = Join-Path $AppRoot "ui"
$Node = "node"

if (-not (Test-Path $AgentExe)) { Write-Error "Agent not found at $AgentExe"; exit 1 }
if (-not (Test-Path (Join-Path $BridgeDir "dist\index.js"))) { Write-Error "Bridge dist not found"; exit 1 }

# Optional: use bundled Node if present
$NodeDir = Join-Path $AppRoot "node"
if (Test-Path (Join-Path $NodeDir "node.exe")) { $Node = Join-Path $NodeDir "node.exe" }

Write-Host "Starting Agent..."
Start-Process -FilePath $AgentExe -WorkingDirectory (Join-Path $AppRoot "agent") -WindowStyle Hidden
Start-Sleep -Seconds 2
Write-Host "Starting Bridge (with static UI)..."
$env:STATIC_UI_DIR = $UiDir
Start-Process -FilePath $Node -ArgumentList "dist/index.js" -WorkingDirectory $BridgeDir -WindowStyle Hidden
Start-Sleep -Seconds 2
Write-Host "Starting Session service..."
Start-Process -FilePath $Node -ArgumentList "dist/index.js" -WorkingDirectory $SessionDir -WindowStyle Hidden
Start-Sleep -Seconds 3
Write-Host "Opening http://localhost:5001"
Start-Process "http://localhost:5001"
Write-Host "LS360-Terminal is running. Close this window to leave processes running (or stop Agent/Bridge/Session manually)."
