import * as grpc from "@grpc/grpc-js";
import * as path from "node:path";
import { fileURLToPath } from "node:url";
import { loadSync } from "@grpc/proto-loader";
const __dirname = path.dirname(fileURLToPath(import.meta.url));
const protoPath = path.resolve(__dirname, "../../../proto/ls360/capture/v1/capture.proto");
const packageDefinition = loadSync(protoPath, {
    keepCase: true,
    longs: String,
    enums: String,
    defaults: true,
    oneofs: true,
});
const proto = grpc.loadPackageDefinition(packageDefinition);
const DEFAULT_ADDRESS = "127.0.0.1";
const DEFAULT_PORT = 5000;
export function createCaptureClient(options = {}) {
    const address = `${options.address ?? DEFAULT_ADDRESS}:${options.port ?? DEFAULT_PORT}`;
    const Client = proto.ls360?.capture?.v1?.CaptureService;
    if (!Client) {
        throw new Error("CaptureService not found in proto; check proto path and package name.");
    }
    return new Client(address, grpc.credentials.createInsecure());
}
//# sourceMappingURL=client.js.map