export interface DeviceInfo {
    device_id: string;
    name: string;
    serial_number: string;
    firmware_version: string;
    is_available: boolean;
}
export interface ListDevicesResponse {
    devices: DeviceInfo[];
    error?: {
        code: number;
        message: string;
        details?: string;
    };
}
export interface StartSessionResponse {
    session_id: string;
    device?: DeviceInfo;
    error?: {
        code: number;
        message: string;
        details?: string;
    };
}
export interface CaptureSlapResponse {
    capture_id: string;
    slap_type: number;
    image_bmp?: Buffer;
    image_wsq?: Buffer;
    width: number;
    height: number;
    segments?: Array<{
        x: number;
        y: number;
        width: number;
        height: number;
        label: string;
    }>;
    quality_scores?: Array<{
        type: string;
        score: number;
        details?: string;
    }>;
    captured_at?: {
        seconds: number;
        nanos: number;
    };
    error?: {
        code: number;
        message: string;
        details?: string;
    };
}
export interface CaptureRollResponse {
    capture_id: string;
    finger: number;
    image_bmp?: Buffer;
    image_wsq?: Buffer;
    width: number;
    height: number;
    quality_scores?: Array<{
        type: string;
        score: number;
        details?: string;
    }>;
    captured_at?: {
        seconds: number;
        nanos: number;
    };
    error?: {
        code: number;
        message: string;
        details?: string;
    };
}
export interface GetDiagnosticsResponse {
    agent_version: string;
    devices: DeviceInfo[];
    active_session_id?: string;
    sdk_version: string;
    extra?: Record<string, string>;
}
//# sourceMappingURL=types.d.ts.map