const BRIDGE_VERSION = "1.0.0";
const PROTO_VERSION = "v1";
export function registerHttpRoutes(app, client, logger) {
    app.get("/health", async (_req, reply) => {
        const agentConnected = client != null;
        return reply.send({ status: "ok", agent_connected: agentConnected });
    });
    app.get("/version", async (_req, reply) => {
        return reply.send({ bridge: BRIDGE_VERSION, proto_version: PROTO_VERSION });
    });
    app.get("/devices", async (_req, reply) => {
        if (!client) {
            return reply.status(503).send({ error: "Agent not connected", devices: [] });
        }
        return new Promise((resolve, reject) => {
            client.listDevices({}, (err, res) => {
                if (err) {
                    logger.warn({ err }, "ListDevices failed");
                    return resolve(reply.status(502).send({ error: err.message, devices: [] }));
                }
                resolve(reply.send({ devices: res?.devices ?? [] }));
            });
        });
    });
}
//# sourceMappingURL=routes.js.map