export declare const SLAP_ORDER: readonly ["right_four_fingers", "left_four_fingers", "two_thumbs"];
export declare const ROLL_ORDER: readonly ["right_thumb", "right_index", "right_middle", "right_ring", "right_little", "left_thumb", "left_index", "left_middle", "left_ring", "left_little"];
export type SlapTypeName = (typeof SLAP_ORDER)[number];
export type FingerName = (typeof ROLL_ORDER)[number];
export declare const DEFAULT_QUALITY_THRESHOLD = 3;
export interface CaptureState {
    session_id: string | null;
    current_step: "idle" | "slap" | "roll";
    slap_index: number;
    roll_index: number;
    accepted_slaps: Record<string, string[]>;
    accepted_rolls: Record<string, string[]>;
    current_attempt: Record<string, number>;
}
export declare function createCaptureState(): CaptureState;
export declare function getNextSlap(state: CaptureState): SlapTypeName | null;
export declare function getNextRoll(state: CaptureState): FingerName | null;
export declare function isSlapAccepted(state: CaptureState, slapType: SlapTypeName): boolean;
export declare function isRollAccepted(state: CaptureState, finger: FingerName): boolean;
export declare function minQualityScore(scores: Array<{
    type: string;
    score: number;
}>): number;
export declare function meetsQualityThreshold(scores: Array<{
    type: string;
    score: number;
}>, threshold?: number): boolean;
//# sourceMappingURL=captureStateMachine.d.ts.map