// Capture order: 4-4-2 then rolls
export const SLAP_ORDER = [
    "right_four_fingers",
    "left_four_fingers",
    "two_thumbs",
];
export const ROLL_ORDER = [
    "right_thumb",
    "right_index",
    "right_middle",
    "right_ring",
    "right_little",
    "left_thumb",
    "left_index",
    "left_middle",
    "left_ring",
    "left_little",
];
export const DEFAULT_QUALITY_THRESHOLD = 3; // NFIQ/NFIQ2: accept if score >= 3
export function createCaptureState() {
    return {
        session_id: null,
        current_step: "idle",
        slap_index: 0,
        roll_index: 0,
        accepted_slaps: {
            right_four_fingers: [],
            left_four_fingers: [],
            two_thumbs: [],
        },
        accepted_rolls: Object.fromEntries(ROLL_ORDER.map((f) => [f, []])),
        current_attempt: {},
    };
}
export function getNextSlap(state) {
    if (state.slap_index >= SLAP_ORDER.length)
        return null;
    return SLAP_ORDER[state.slap_index];
}
export function getNextRoll(state) {
    if (state.roll_index >= ROLL_ORDER.length)
        return null;
    return ROLL_ORDER[state.roll_index];
}
export function isSlapAccepted(state, slapType) {
    return (state.accepted_slaps[slapType]?.length ?? 0) > 0;
}
export function isRollAccepted(state, finger) {
    return (state.accepted_rolls[finger]?.length ?? 0) > 0;
}
export function minQualityScore(scores) {
    if (scores.length === 0)
        return 0;
    return Math.min(...scores.map((s) => s.score));
}
export function meetsQualityThreshold(scores, threshold = DEFAULT_QUALITY_THRESHOLD) {
    return minQualityScore(scores) >= threshold;
}
//# sourceMappingURL=captureStateMachine.js.map