/**
 * Optional integration: when SESSION_SERVICE_URL is set, forward each capture_result
 * to the session-service. Fire-and-forget; failures are logged but do not affect the client.
 */
const SESSION_SERVICE_URL = process.env.SESSION_SERVICE_URL?.replace(/\/$/, "");
export function isSessionServiceConfigured() {
    return Boolean(SESSION_SERVICE_URL);
}
export function forwardCaptureToSessionService(params, logger) {
    if (!SESSION_SERVICE_URL || !params.wsq_buffer || params.wsq_buffer.length === 0) {
        return;
    }
    const quality = params.quality_scores[0];
    const body = {
        finger_position: params.finger_position,
        capture_kind: params.kind,
        attempt: params.attempt,
        quality_score: quality?.score ?? 0,
        quality_type: quality?.type ?? "NFIQ",
        wsq_base64: params.wsq_buffer.toString("base64"),
        width: params.width,
        height: params.height,
        captured_at: params.captured_at,
    };
    fetch(`${SESSION_SERVICE_URL}/sessions/${params.session_id}/captures`, {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(body),
    }).catch((err) => {
        logger.warn({ err, session_id: params.session_id }, "session-service forward capture failed");
    });
}
//# sourceMappingURL=forwardCapture.js.map