export interface CaptureResultSchema {
    schema_version: string;
    capture_id: string;
    session_id: string;
    applicant_id: string | null;
    kind: "slap" | "roll";
    slap_type: string | null;
    finger: string | null;
    attempt: number;
    accepted: boolean;
    paths: CapturePaths;
    width: number;
    height: number;
    quality_scores: Array<{
        type: string;
        score: number;
        details?: string;
    }>;
    segments: Array<{
        x: number;
        y: number;
        width: number;
        height: number;
        label: string;
    }>;
    captured_at: string;
    created_at: string;
}
export declare function sessionDir(sessionId: string, baseDir: string): string;
export declare function slapFileName(slapType: string, attempt: number, ext?: "png" | "bmp"): string;
export declare function rollFileName(finger: string, attempt: number, ext?: "png" | "bmp"): string;
export declare function sidecarPath(imagePath: string): string;
export declare function buildResultSchema(opts: {
    capture_id: string;
    session_id: string;
    applicant_id?: string;
    kind: "slap" | "roll";
    slap_type?: string | null;
    finger?: string | null;
    attempt: number;
    accepted: boolean;
    paths: CapturePaths;
    width: number;
    height: number;
    quality_scores?: Array<{
        type: string;
        score: number;
        details?: string;
    }>;
    segments?: Array<{
        x: number;
        y: number;
        width: number;
        height: number;
        label: string;
    }>;
    captured_at: string;
}): CaptureResultSchema;
export interface CapturePaths {
    image_raw: string;
    image_wsq?: string;
}
export declare function ensureSessionDir(sessionId: string, baseDir: string): string;
export declare function writeCaptureResult(baseDir: string, result: CaptureResultSchema): void;
export declare function writeImageBuffer(dir: string, fileName: string, data: Buffer): string;
//# sourceMappingURL=captureStore.d.ts.map