export function sessionDir(sessionId, baseDir) {
    return `${baseDir}/sessions/${sessionId}`;
}
export function slapFileName(slapType, attempt, ext = "png") {
    return `slap_${slapType}_attempt_${attempt}.${ext}`;
}
export function rollFileName(finger, attempt, ext = "png") {
    return `roll_${finger}_attempt_${attempt}.${ext}`;
}
export function sidecarPath(imagePath) {
    return imagePath.replace(/\.(png|bmp|wsq)$/i, ".json");
}
export function buildResultSchema(opts) {
    return {
        schema_version: "1.0",
        capture_id: opts.capture_id,
        session_id: opts.session_id,
        applicant_id: opts.applicant_id ?? null,
        kind: opts.kind,
        slap_type: opts.slap_type ?? null,
        finger: opts.finger ?? null,
        attempt: opts.attempt,
        accepted: opts.accepted,
        paths: opts.paths,
        width: opts.width,
        height: opts.height,
        quality_scores: opts.quality_scores ?? [],
        segments: opts.segments ?? [],
        captured_at: opts.captured_at,
        created_at: new Date().toISOString(),
    };
}
import fs from "node:fs";
import path from "node:path";
export function ensureSessionDir(sessionId, baseDir) {
    const dir = sessionDir(sessionId, baseDir);
    fs.mkdirSync(dir, { recursive: true });
    return dir;
}
export function writeCaptureResult(baseDir, result) {
    const dir = sessionDir(result.session_id, baseDir);
    const relPath = result.kind === "slap"
        ? slapFileName(result.slap_type ?? "unknown", result.attempt, "png")
        : rollFileName(result.finger ?? "unknown", result.attempt, "png");
    const jsonPath = path.join(dir, sidecarPath(relPath));
    fs.writeFileSync(jsonPath, JSON.stringify(result, null, 2), "utf-8");
}
export function writeImageBuffer(dir, fileName, data) {
    const fullPath = path.join(dir, fileName);
    fs.writeFileSync(fullPath, data);
    return fullPath;
}
//# sourceMappingURL=captureStore.js.map