export type ClientMessage = {
    type: "ping";
    id?: string;
} | {
    type: "start_session";
    id?: string;
    device_id: string;
    session_id?: string;
    applicant_id?: string;
    metadata?: Record<string, string>;
} | {
    type: "end_session";
    id?: string;
    session_id: string;
} | {
    type: "end_all_sessions";
    id?: string;
} | {
    type: "start_preview";
    id?: string;
    session_id: string;
} | {
    type: "stop_preview";
    id?: string;
    session_id: string;
} | {
    type: "capture_slap";
    id?: string;
    session_id: string;
    slap_type: "right_four_fingers" | "left_four_fingers" | "two_thumbs";
} | {
    type: "capture_roll";
    id?: string;
    session_id: string;
    finger: string;
} | {
    type: "list_devices";
    id?: string;
} | {
    type: "get_diagnostics";
    id?: string;
};
export interface DeviceInfoMsg {
    device_id: string;
    name: string;
    serial_number: string;
    firmware_version: string;
    is_available: boolean;
}
export interface SlapResultPayload {
    slap_type: string;
    image_bmp_base64?: string;
    image_wsq_base64?: string;
    width: number;
    height: number;
    segments?: Array<{
        x: number;
        y: number;
        width: number;
        height: number;
        label: string;
    }>;
    quality_scores?: Array<{
        type: string;
        score: number;
        details?: string;
    }>;
    captured_at: string;
}
export interface RollResultPayload {
    finger: string;
    image_bmp_base64?: string;
    image_wsq_base64?: string;
    width: number;
    height: number;
    quality_scores?: Array<{
        type: string;
        score: number;
        details?: string;
    }>;
    captured_at: string;
}
export type ServerMessage = {
    event: "pong";
    id?: string;
} | {
    event: "device_status";
    devices: DeviceInfoMsg[];
} | {
    event: "session_status";
    session_id: string;
    status: "started" | "ended";
    device_id?: string;
} | {
    event: "preview_frame";
    session_id: string;
    data: string;
    width: number;
    height: number;
    captured_at: string;
} | {
    event: "capture_progress";
    session_id: string;
    step: string;
    message?: string;
} | {
    event: "capture_result";
    session_id: string;
    capture_id: string;
    kind: "slap" | "roll";
    payload: SlapResultPayload | RollResultPayload;
} | {
    event: "error";
    code: string;
    message: string;
    details?: string;
    request_id?: string;
} | {
    event: "command_ack";
    id?: string;
    success: boolean;
    error?: string;
};
//# sourceMappingURL=schemas.d.ts.map