import { createWsHandlers } from "./handlers.js";
export function registerWsRoute(app, getClient, logger, cacheDir) {
    app.get("/ws", { websocket: true }, (socket, req) => {
        const client = getClient();
        const handlers = createWsHandlers(client, logger, cacheDir);
        const requestId = req.headers["x-request-id"] ?? undefined;
        socket.on("message", (raw) => {
            const str = typeof raw === "string" ? raw : raw.toString("utf-8");
            handlers.handleMessage(socket, str, requestId);
        });
    });
}
//# sourceMappingURL=server.js.map