'use strict'
const neostandard = require('neostandard')

module.exports = [
  ...neostandard({
    ignores: [
      'lib/config-validator.js',
      'lib/error-serializer.js',
      'test/same-shape.test.js',
      'test/types/import.js'
    ],
    ts: true
  }),
  {
    rules: {
      'comma-dangle': ['error', 'never'],
      'max-len': ['error', {
        code: 120,
        tabWidth: 2,
        ignoreUrls: true,
        ignoreStrings: true,
        ignoreTemplateLiterals: true,
        ignoreRegExpLiterals: true,
        ignoreComments: true,
        ignoreTrailingComments: true
      }]
    }
  },
  {
    files: ['**/*.d.ts'],
    rules: {
      'max-len': 'off'
    }
  }
]
