import { supabase } from "../db/client.js";
import { deleteArtifact } from "./encrypt.js";
export async function purgeExpiredArtifacts(logger) {
    if (!supabase)
        return 0;
    const now = new Date().toISOString();
    const { data: rows, error } = await supabase
        .from("fingerprint_captures")
        .select("id, artifact_ref")
        .not("artifact_ref", "is", null)
        .lt("artifact_expires_at", now);
    if (error) {
        logger.warn({ err: error }, "purge: fetch failed");
        return 0;
    }
    let purged = 0;
    for (const row of rows ?? []) {
        if (row.artifact_ref) {
            try {
                await deleteArtifact(row.artifact_ref);
            }
            catch (e) {
                logger.warn({ ref: row.artifact_ref, err: e }, "purge: delete file failed");
            }
            await supabase
                .from("fingerprint_captures")
                .update({ artifact_ref: null, artifact_expires_at: null })
                .eq("id", row.id);
            purged++;
        }
    }
    if (purged > 0)
        logger.info({ purged }, "purge: expired artifacts removed");
    return purged;
}
//# sourceMappingURL=purge.js.map