import type { Logger } from "pino";
export type AuditEventType = "session_created" | "demographics_entered" | "capture_started" | "capture_completed" | "package_built" | "submitted" | "ack_received" | "nak_received" | "artifact_deleted" | "status_changed";
export interface AuditPayload {
    session_id?: string;
    event_type: AuditEventType;
    actor?: string;
    payload?: Record<string, unknown>;
    ip_address?: string;
}
export declare function setAuditLogger(logger: Logger): void;
export declare function audit(params: AuditPayload): Promise<void>;
//# sourceMappingURL=index.d.ts.map