let auditLogger = null;
export function setAuditLogger(logger) {
    auditLogger = logger;
}
export async function audit(params) {
    const { supabase } = await import("../db/client.js");
    if (supabase) {
        const { error } = await supabase.from("audit_logs").insert({
            session_id: params.session_id ?? null,
            event_type: params.event_type,
            actor: params.actor ?? null,
            payload: params.payload ?? {},
            ip_address: params.ip_address ?? null,
        });
        if (error)
            auditLogger?.warn({ err: error, audit: params }, "audit insert failed");
    }
    else {
        auditLogger?.info({ audit: params }, "audit");
    }
}
//# sourceMappingURL=index.js.map