import { getSupabase } from "./client.js";
export async function getSession(id) {
    const { data, error } = await getSupabase().from("sessions").select("*").eq("id", id).single();
    if (error && error.code !== "PGRST116")
        throw error;
    return data;
}
export async function insertSession(row) {
    const { error } = await getSupabase().from("sessions").insert({
        id: row.id,
        ori: row.ori,
        purpose: row.purpose,
        operator_id: row.operator_id ?? null,
        operator_name: row.operator_name ?? null,
        device_id: row.device_id ?? null,
        device_serial: row.device_serial ?? null,
        applicant_id: row.applicant_id ?? null,
        status: "CREATED",
        created_at: new Date().toISOString(),
        updated_at: new Date().toISOString(),
    });
    if (error)
        throw error;
}
export async function updateSessionStatus(id, status, tcn) {
    const updates = { status, updated_at: new Date().toISOString() };
    if (tcn !== undefined)
        updates.tcn = tcn;
    const { error } = await getSupabase().from("sessions").update(updates).eq("id", id);
    if (error)
        throw error;
}
//# sourceMappingURL=sessions.js.map