import Fastify from "fastify";
import cors from "@fastify/cors";
import { registerSessionRoutes } from "./api/routes.js";
import { setAuditLogger } from "./audit/index.js";
import { purgeExpiredArtifacts } from "./artifacts/purge.js";
const PORT = Number(process.env.SESSION_SERVICE_PORT) || 5003;
const app = Fastify({
    logger: { level: process.env.LOG_LEVEL ?? "info" },
});
setAuditLogger(app.log);
await app.register(cors, { origin: true }); // allow browser requests from any origin (e.g. UI on :5000)
await registerSessionRoutes(app);
app.get("/health", async (_, reply) => {
    return reply.send({ status: "ok", service: "session-service" });
});
let purgeInterval = null;
if (process.env.SUPABASE_URL) {
    purgeInterval = setInterval(() => {
        purgeExpiredArtifacts(app.log).catch((e) => app.log.warn(e, "purge failed"));
    }, 60 * 60 * 1000);
}
try {
    await app.listen({ port: PORT, host: "0.0.0.0" });
    app.log.info({ port: PORT }, "session-service listening");
}
finally {
    if (purgeInterval)
        clearInterval(purgeInterval);
}
//# sourceMappingURL=index.js.map