export interface ORIDemographicsConfig {
    required: string[];
    optional: string[];
}
export interface ORIFingerprintsConfig {
    required: {
        rolls: string[];
        slaps: string[];
    };
    quality_threshold: number;
    max_attempts_per_finger: number;
}
export interface ORIConfig {
    ori: string;
    description?: string;
    version?: string;
    demographics: ORIDemographicsConfig;
    fingerprints: ORIFingerprintsConfig;
    photo: {
        required: boolean;
    };
    purpose_codes: {
        allowed: string[];
    };
}
export declare function getORIConfigsDir(): string;
export declare function loadORIConfig(ori: string): Promise<ORIConfig>;
//# sourceMappingURL=oriConfig.d.ts.map