import fs from "node:fs/promises";
import path from "node:path";
import { parse } from "yaml";
const defaultConfig = {
    ori: "DEFAULT",
    description: "Default ORI config",
    version: "1.0",
    demographics: {
        required: ["first_name", "last_name", "date_of_birth", "sex"],
        optional: ["middle_name", "race", "eye_color", "height", "weight", "street_address", "city", "state", "zip", "country"],
    },
    fingerprints: {
        required: {
            rolls: [
                "right_thumb",
                "right_index",
                "right_middle",
                "right_ring",
                "right_little",
                "left_thumb",
                "left_index",
                "left_middle",
                "left_ring",
                "left_little",
            ],
            slaps: ["right_four_fingers", "left_four_fingers", "two_thumbs"],
        },
        quality_threshold: 3,
        max_attempts_per_finger: 3,
    },
    photo: { required: false },
    purpose_codes: { allowed: ["C", "U", "O"] },
};
let configCache = new Map();
export function getORIConfigsDir() {
    return process.env.ORI_RULES_DIR ?? path.join(process.cwd(), "..", "shared", "ori-rules");
}
export async function loadORIConfig(ori) {
    const cached = configCache.get(ori);
    if (cached)
        return cached;
    const dir = getORIConfigsDir();
    const base = path.join(dir, ori.toLowerCase().replace(/[^a-z0-9]/g, "_"));
    const candidates = [`${base}.yaml`, `${base}.yml`, path.join(dir, "fdle_example.yaml")];
    for (const file of candidates) {
        try {
            const raw = await fs.readFile(file, "utf8");
            const parsed = parse(raw);
            configCache.set(ori, parsed);
            return parsed;
        }
        catch {
            continue;
        }
    }
    configCache.set(ori, defaultConfig);
    return { ...defaultConfig, ori };
}
//# sourceMappingURL=oriConfig.js.map