import { randomUUID } from "node:crypto";
import { getSupabase } from "../db/client.js";
import * as audit from "../audit/index.js";
export async function createSession(req) {
    const id = randomUUID();
    const supabase = getSupabase();
    const { error } = await supabase.from("sessions").insert({
        id,
        ori: req.ori,
        purpose: req.purpose,
        operator_id: req.operator_id ?? null,
        operator_name: req.operator_name ?? null,
        device_id: req.device_id ?? null,
        device_serial: req.device_serial ?? null,
        applicant_id: req.applicant_id ?? null,
        status: "CREATED",
        created_at: new Date().toISOString(),
        updated_at: new Date().toISOString(),
    });
    if (error)
        throw error;
    await audit.audit({ session_id: id, event_type: "session_created", actor: req.operator_id ?? undefined, payload: { ori: req.ori } });
    return { session_id: id, status: "CREATED" };
}
//# sourceMappingURL=create.js.map