import { canTransition } from "shared";
import { getSession } from "../db/sessions.js";
import { updateSessionStatus } from "../db/sessions.js";
import * as audit from "../audit/index.js";
export async function transitionSession(sessionId, newStatus, actor, tcn) {
    const session = await getSession(sessionId);
    if (!session)
        return { ok: false, error: "Session not found" };
    if (!canTransition(session.status, newStatus)) {
        return { ok: false, error: `Invalid transition from ${session.status} to ${newStatus}` };
    }
    await updateSessionStatus(sessionId, newStatus, tcn);
    await audit.audit({
        session_id: sessionId,
        event_type: "status_changed",
        actor,
        payload: { from: session.status, to: newStatus, tcn },
    });
    return { ok: true };
}
//# sourceMappingURL=stateMachine.js.map