export const SESSION_STATUSES = [
    "CREATED",
    "DEMOGRAPHICS_ENTERED",
    "FINGER_CAPTURE_IN_PROGRESS",
    "QUALITY_PASS",
    "PACKAGE_READY",
    "SUBMITTED",
    "ACCEPTED",
    "REJECTED",
];
const ALLOWED_TRANSITIONS = {
    CREATED: ["DEMOGRAPHICS_ENTERED", "FINGER_CAPTURE_IN_PROGRESS"],
    DEMOGRAPHICS_ENTERED: ["FINGER_CAPTURE_IN_PROGRESS"],
    FINGER_CAPTURE_IN_PROGRESS: ["FINGER_CAPTURE_IN_PROGRESS", "QUALITY_PASS"],
    QUALITY_PASS: ["PACKAGE_READY", "FINGER_CAPTURE_IN_PROGRESS"],
    PACKAGE_READY: ["SUBMITTED"],
    SUBMITTED: ["ACCEPTED", "REJECTED"],
    ACCEPTED: [],
    REJECTED: [],
};
export function canTransition(from, to) {
    return ALLOWED_TRANSITIONS[from]?.includes(to) ?? false;
}
//# sourceMappingURL=stateMachine.js.map