export type SessionStatus = "CREATED" | "DEMOGRAPHICS_ENTERED" | "FINGER_CAPTURE_IN_PROGRESS" | "QUALITY_PASS" | "PACKAGE_READY" | "SUBMITTED" | "ACCEPTED" | "REJECTED";
export interface Session {
    id: string;
    ori: string;
    purpose: string;
    operator_id: string | null;
    operator_name: string | null;
    device_id: string | null;
    device_serial: string | null;
    status: SessionStatus;
    tcn: string | null;
    applicant_id: string | null;
    created_at: string;
    updated_at: string;
}
export interface SubjectDemographics {
    session_id: string;
    first_name: string | null;
    last_name: string | null;
    middle_name: string | null;
    date_of_birth: string | null;
    sex: string | null;
    race: string | null;
    eye_color: string | null;
    height: string | null;
    weight: string | null;
    street_address: string | null;
    city: string | null;
    state: string | null;
    zip: string | null;
    country: string | null;
    ssn: string | null;
    updated_at: string;
}
export interface FingerprintCapture {
    id: string;
    session_id: string;
    finger_position: string;
    capture_kind: "roll" | "slap";
    attempt: number;
    is_best: boolean;
    quality_score: number;
    quality_type: string;
    image_hash: string;
    artifact_ref: string | null;
    artifact_expires_at: string | null;
    width: number;
    height: number;
    captured_at: string;
}
export interface StoreCaptureResultParams {
    session_id: string;
    finger_position: string;
    capture_kind: "roll" | "slap";
    attempt: number;
    quality_score: number;
    quality_type: string;
    wsq_buffer: Buffer;
    width: number;
    height: number;
    captured_at: string;
}
export interface SubmissionResult {
    ackNak: "ACK" | "NAK";
    tcn?: string;
    errors?: Array<{
        code: string;
        message: string;
        field?: string;
    }>;
    rawResponse?: string;
    respondedAt: string;
}
export interface ORIValidationResult {
    valid: boolean;
    ori: string;
    errors: Array<{
        field: string;
        code: string;
        message: string;
    }>;
    warnings: Array<{
        field: string;
        code: string;
        message: string;
    }>;
    missing_required_fingers: string[];
    missing_required_demographics: string[];
    photo_required: boolean;
    photo_provided: boolean;
}
//# sourceMappingURL=session.d.ts.map